<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Ship;
use Auth; 
use Session;
use App\Models\User;

class LoginController extends Controller
{

    public function create()
    {
        return view('Auth.index',[
            'title' => 'PT. BAg | Login',
        ]);
    }

    public function store(Request $request)
    {
        $credentials = $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        
        if (!Auth::attempt($credentials))
        {
            return back()->withErrors([
                'email' => 'Proses login gagal! Silakan coba lagi!',
            ]);
        } else {
            $userId = Auth::user()->id;
            
            $user1 = User::find($userId, ['name', 'email']);
            //dd($user->email);
            // session(['name' => $user->name]);
            // session(['email' => $user->email]);
            Session::put('name',$user1->name );
            Session::put('email', $user1->email);
             return redirect('dashboard');
        }

        //$request->user()->createToken('access_token')->plainTextToken;
        //$request->session()->regenerate();
        //return back();
        //return response()->json($response,$status);
    }

    public function dashboard(Request $request)
    {
        $ships = Ship::all();
        return view('AdminDashboard',[
            'title' => 'Admin Dashboard',
            'ships' => $ships,
        ]);
        //return $request->user();
    }

    public function destroy(Request $request)
    {
        $request->user()->tokens()->where('tokenable_id',Auth::user())->delete();
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->to('/login');
    }

}
