<?php

namespace App\Http\Controllers;

use App\Models\Ship;
use Illuminate\Http\Request;
use Validator;
class ShipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    private $m = Ship::class;
    private $pk = 'ship_id';

    public function index()
    {

        $hasil = Ship::all();
        return view('Inventory.ship',[
            'title' => 'Ship Data',
            'ships' => $hasil,
        ]);
        //$data = Ship::all();
        //return response()->json(ShipResource::Collection($data));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator = $request->validate([
            'ship_id' => 'required',
            'ship_name' => 'required',
            'ship_desc' => 'required',
            'ship_image' => 'image|file|max:2048',
        ]);
        if('ship_id' == $request->ship_id){
            return redirect()->back();
            
        } else {
            if($request->file('ship_image')){
                $validator['ship_image'] = $request->file('ship_image')->store('img');
            }
            Ship::create($validator);
            return redirect()->back();
        }

        
    }

        //dd($validator->errors());
        // if($validator->fails()) {
        //     return redirect()
        //     ->back()
        //     ->withInput()
        //     ->withErrors([
        //         'errors' => 'Tidak dapat menyimpan data'
        //     ]);
        // } else {
        //     if($request->hasFile('ship_image')){
        //         $filenameWithExt = $request->file('ship_image')->getClientOriginalName();
        //         $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //         $extension = $request->file('ship_image')->getClientOriginalExtension();
        //         $filenameSimpan = $filename.'_'.time().'.'.$extension;
               
        //         $path = $request->file('ship_image')->storeAs('public/assets/images/ship/', $filenameSimpan);
        //     }else{
        //         $filenameSimpan = 'gada image';
        //         with([
        //             'success' => 'Data kapal sudah berhasil disimpan'
        //         ]);
        //     }
        //     dd($filenameSimpan);
        //     $ships = Ship::create([
        //         'ship_id' => $request->ship_id,
        //         'ship_name' => $request->ship_name,
        //         'ship_desc' => $request->ship_desc,
        //         'ship_image' => $request->$filenameSimpan,
        //     ]);
    
        //     if ($ships)
        //     {
        //         return redirect()->back()
        //         ->with([
        //             'success' => 'Data kapal sudah berhasil disimpan'
        //         ]);            
        //     } else {
        //         return redirect()
        //             ->back()
        //             ->withInput()
        //             ->with([
        //                 'error' => 'Some problem occurred, please try again'
        //             ]);
        //     }
        // }
        
        
        //return $this->rStore($this->m, $request, $this->pk);
        
        // }
        
    // }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Ship  $ship
     * @return \Illuminate\Http\Response
     */
    public function show($ship_id)
    {
        
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Ship  $ship
     * @return \Illuminate\Http\Response
     */
    public function edit($ship_id)
    {
        $ship = Ship::find($ship_id);
        
        return view('Inventory.edit_ship', [
            'title' => 'Ship Data',
            'ship'=>$ship
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Ship  $ship
     * @return \Illuminate\Http\Response
     */

    public function update(Request $request, Ship $ship)
    {
        // $ship = Ship::find($request->ship_id);
        // $ship->ship_id=$request->ship_id;
        // $ship->ship_name=$request->ship_name;
        // $ship->ship_desc=$request->ship_desc;
        // $ship->ship_image=$request->ship_image;

        // if($request->file('ship_image')) {
        //     $request->file('ship_image')->store('img');
        // }

        // $request->save();

        // return view('Inventory.ship', [
        //         'title' => 'Ship Data'
        //      ])->with('success', 'data berhasil terupdate');

        $validator = $request->validate([
            'ship_id' => 'required',
            'ship_name' => 'required',
            'ship_desc' => 'required',
        ]);

        if($request->file('ship_image')){
            $validator['ship_image'] = $request->file('ship_image')->store('img');
        }
        
        Ship::where('ship_id', $request->ship_id)
               ->update($validator);

               return redirect('inv/ship');
        // return view('Inventory.ship', [
        //     'title' => 'Ship Data'
        // ])->with('success', 'data berhasil terupdate');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Ship  $ship
     * @return \Illuminate\Http\Response
     */
    public function destroy($ship_id)
    {
        $ship = Ship::find($ship_id);

        $ship->delete();
        // Ship::destroy($ship->ship_id);
        return redirect()->back();
    }
}
