<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCrewsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('crew', function (Blueprint $table) {
            $table->id();
            $table->string('crew_id',15)->unique();
            $table->string('nama');
            $table->string('pekerjaan');
            $table->string('tempat_lahir');
            $table->string('tanggal_lahir');
            $table->string('jenis_kelamin');
            $table->string('agama' );
            $table->string('email');
            $table->string('negara');
            $table->string('alamat');
            $table->string('telepon');
            $table->string('handphone',15);
            $table->string('status_menikah');
            $table->string('foto');
            $table->string('mulai_kerja');
            $table->string('akhir_kerja');
            $table->string('info_lain');
            $table->string('id_kapal');
            $table->string('kd_jabatan');
            $table->string('aktif',1);
            $table->integer('tinggi_badan');
            $table->integer('berat_badan');
            $table->string('golongan_darah',3);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('crew');
    }
}
