@extends('layout.main')
@section('container')



<!-- Page Content-->
<div class="page-content">
    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Parts Data</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Master</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Inventory</a></li>
                            <li class="breadcrumb-item active">parts</li>
                        </ol>
                    </div><!--end col-->
                    <div class="col-auto align-self-center">
                        <a href="#" class="btn btn-sm btn-outline-primary" id="Dash_Date">
                            <span class="day-name" id="Day_Name">Today:</span>&nbsp;
                            <span class="" id="Select_date">Jan 11</span>
                            <i data-feather="calendar" class="align-self-center icon-xs ms-1"></i>
                        </a>
                        <a href="#" class="btn btn-sm btn-outline-primary">
                            <i data-feather="download" class="align-self-center icon-xs"></i>
                        </a>
                    </div><!--end col-->  
                </div><!--end row-->                                                              
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="nav-link">
                            <a class=" btn btn-sm btn-soft-primary"  href="/inv/part/add"><i class="fas fa-plus me-2"></i>New Part</a>
                        </div>
                    </div><!--end card-header-->
                    <div class="card-body">
                        <table id="row_callback" class="table table-striped table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr>
                                <th>Main Group</th>
                                <th>Group</th>
                                <th>Sub Group</th>
                                <th>Unit</th>
                                <th>Component</th>
                                <th>Part ID</th>
                                <th>Name</th>
                                <th>List No.</th>
                                <th>Drawing No.</th>
                                <th>Volume</th>
                                <th>Maker</th>
                                <th>Serial No.</th>
                                <th></th>
                            </tr>
                            </thead>
                         
                            <tbody>
                           
                                @foreach ($hasil as $mg)
                                <tr>
                                    <td>{{ $mg->id }} - </td>
                                    <td>{{ $mg->id_group }}</td>
                                    <td>{{ $mg->id_subgroup }}</td>
                                    <td>{{ $mg->id_unit }}</td>
                                    <td>{{ $mg->id_component }}</td>
                                    <td>{{ $mg->id_part }}</td>
                                    <td>{{ $mg->name }}</td>
                                    <td>{{ $mg->list_no }}</td>
                                    <td>{{ $mg->drawing_no }}</td>
                                    <td>{{ $mg->volume }}</td>
                                    <td>{{ $mg->maker }}</td>
                                    <td>{{ $mg->serial_no }}</td>
                                    <td class="text-end">                                                       
                                        <a href="#"><i class="las la-pen text-secondary font-16"></i></a>
                                        <a href="#"><i class="las la-trash-alt text-secondary font-16"></i></a>
                                    </td> 
                                </tr>   
                                @endforeach


                                {{-- <td>101111100011</td>
                                <td><img src="{{ url('') }}/assets/images/users/user-3.jpg" alt="" class="rounded-circle thumb-xs me-1">Tiger Nixon</td>
                                <td>packing</td>
                                <td>1</td>
                                <td>10</td>
                                <td>101</td>
                                <td>101001</td>
                                <td></td>
                                <td></td> --}}
                               
                           
                      
                            </tbody>
                        </table>        
                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->

          
    </div><!-- container -->

    <footer class="footer text-center text-sm-start">
        &copy; <script>
            document.write(new Date().getFullYear())
        </script> Dastone <span class="text-muted d-none d-sm-inline-block float-end">Crafted with <i
                class="mdi mdi-heart text-danger"></i> by Mannatthemes</span>
    </footer><!--end footer-->
</div>
<!-- end page content -->

<script type="text/javascript">

    $(this.document).ready(function() {
    
    //Tampilkan Group
    
    $('select[name="maingroup"]').on('change', function() {
        var mg_id = $(this).val();
        console.log(mg_id);
        if(mg_id) {
            $.ajax({
                url: 'http://127.0.0.1:8000/api/inv/showgroup/'+ mg_id,
                type: "GET",
                dataType: "json",
                headers: { 
                    Authorization: "Bearer 2|D0rtHV6wMSXcHOYU2HSFFVTCcu9nxQ30PlBg8eQR" 
                },
                success:function(data) {
                    //token = data.response.properties.session_token;
                    //dd(data);
                    $('select[name="group"]').empty();
                    $('select[name="group"]').append('<option value="">Select Group</option>');
                    $.each(data, function(key, value) {
                        console.log(data);
                        $('select[name="group"]').append('<option value="'+ value.id_group +'">'+ value.id_group + ' - ' + value.name +'</option>');
                    });
                }
    
            });
    
        }else{
    
            $('select[name="group"]').empty();
    
        }
    
    });
    

    $('select[name="group"]').on('change', function() {
        var g_id = $(this).val();
        console.log(g_id);
        if(g_id) {
            $.ajax({
                url: 'http://127.0.0.1:8000/api/inv/showsubgroup/'+ g_id,
                type: "GET",
                dataType: "json",
                headers: { 
                    Authorization: "Bearer 2|D0rtHV6wMSXcHOYU2HSFFVTCcu9nxQ30PlBg8eQR" 
                },
                success:function(data) {
                    //token = data.response.properties.session_token;
                    //dd(data);
                    $('select[name="subgroup"]').empty();
                    $('select[name="subgroup"]').append('<option value="">Select Sub Group</option>');
                    $.each(data, function(key, value) {
                        console.log(data);
                        $('select[name="subgroup"]').append('<option value="'+ value.id_subgroup +'">'+ value.id_subgroup + ' - ' + value.name +'</option>');
                    });
                }
    
            });
    
        }else{
    
            $('select[name="subgroup"]').empty();
    
        }
    
    });

    $('select[name="subgroup"]').on('change', function() {
        var sg_id = $(this).val();
        console.log(sg_id);
        if(sg_id) {
            $.ajax({
                url: 'http://127.0.0.1:8000/api/inv/showunit/'+ sg_id,
                type: "GET",
                dataType: "json",
                headers: { 
                    Authorization: "Bearer 2|D0rtHV6wMSXcHOYU2HSFFVTCcu9nxQ30PlBg8eQR" 
                },
                success:function(data) {
                    //token = data.response.properties.session_token;
                    //dd(data);
                    $('select[name="unit"]').empty();
                    $('select[name="unit"]').append('<option value="">Select Unit</option>');
                    $.each(data, function(key, value) {
                        console.log(data);
                        $('select[name="unit"]').append('<option value="'+ value.id_unit +'">'+ value.id_unit + ' - ' + value.name +'</option>');
                    });
                }
    
            });
    
        }else{
    
            $('select[name="unit"]').empty();
    
        }
    
    });

    $('select[name="unit"]').on('change', function() {
        var u_id = $(this).val();
        console.log(u_id);
        if(u_id) {
            $.ajax({
                url: 'http://127.0.0.1:8000/api/inv/showcomponent/'+ u_id,
                type: "GET",
                dataType: "json",
                headers: { 
                    Authorization: "Bearer 2|D0rtHV6wMSXcHOYU2HSFFVTCcu9nxQ30PlBg8eQR" 
                },
                success:function(data) {
                    //token = data.response.properties.session_token;
                    console.log(data);
                    $('select[name="component"]').empty();
                    $('select[name="component"]').append('<option value="">Select Component</option>');
                    $.each(data, function(key, value) {
                        console.log(data);
                        $('select[name="component"]').append('<option value="'+ value.id_component +'">'+ value.id_component + ' - ' + value.name +'</option>');
                    });
                }
    
            });
    
        }else{
    
            $('select[name="component"]').empty();
    
        }
    
    });


    });
    
    </script>

@endsection



