@extends('layout.Main')
@section('container')
<div class="page-content">
    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="col-sm-12">
            <div class="page-title-box">
                <div class="row">
                    <div class="col">
                        <h4 class="page-title">Edit Ship Data</h4>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Inventory</a></li>
                            <li class="breadcrumb-item"><a href="javascript:void(0);">Ship</a></li>
                            <li class="breadcrumb-item active">Edit Ship Data</li>
                        </ol>
                    </div><!--end col-->
                    <div class="col-auto align-self-center">
                        <a href="#" class="btn btn-sm btn-outline-primary" id="Dash_Date">
                            <span class="day-name" id="Day_Name">Today:</span>&nbsp;
                            <span class="" id="Select_date">Jan 11</span>
                            <i data-feather="calendar" class="align-self-center icon-xs ms-1"></i>
                        </a>
                    </div><!--end col-->  
                </div><!--end row-->                                                              
            </div><!--end page-title-box-->
        </div><!--end col-->
    </div><!--end row-->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                    </div><!--end card-header-->
                    <div class="card-body">
                        <form method="POST" action="/inv/ship/update/{{$ship->ship_id}}">    
                            @csrf
                                <div class="mb-2 row">
                                    <label for="example-text-input-sm" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Ship ID</label>
                                    <div class="col-sm-5">
                                        <input class="form-control form-control-sm" type="text" name="ship_id" value=" {{ $ship->ship_id }} " readonly>
                                    </div>
                                </div>   
                                <div class="mb-2 row">
                                    <label for="example-text-input-sm" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Name</label>
                                    <div class="col-sm-5">
                                        <input class="form-control form-control-sm" type="text" name="ship_name" value=" {{ $ship->ship_name }} ">
                                    </div>
                                </div>       
                                <div class="mb-2 row">
                                    <label for="example-text-input-sm" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Description</label>
                                    <div class="col-sm-5">
                                        <textarea class="form-control form-control-sm" rows="3" name="ship_desc" type="text">{{ $ship->ship_desc }}</textarea>
                                    </div>
                                </div>
                                <div class="mb-2 row">
                                    <div class="col-sm-4 text-end">
                                        <button type="submit" id="mg_update" class="btn btn-primary"><i class="mdi mdi-check-all me-2"></i>Update</button>
                                    </div>
                                </div>   
                        </form>   
                    </div>
                </div>
            </div> <!-- end col -->
        </div> <!-- end row -->
        </div><!-- container -->

    <footer class="footer text-center text-sm-start">
        &copy; <script>
            document.write(new Date().getFullYear())
        </script> Dastone <span class="text-muted d-none d-sm-inline-block float-end">Crafted with <i
                class="mdi mdi-heart text-danger"></i> by AIN Production</span>
    </footer><!--end footer-->
</div>
<!-- end page content -->
@endsection