@extends('layout.main')
@section('container')
<!-- Page Content-->
<div class="page-content">
    <div class="container-fluid">
        <!-- Page-Title -->
        <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
    
                                    <h4 class="mt-0 header-title">Child rows example</h4>
                                    <p class="text-muted mb-3">The DataTables API has a number of methods for attaching 
                                        child rows to a parent row in the DataTable. This can be used to show additional 
                                        information about a row, useful for cases where you wish to convey more information 
                                        about a row than there is space for in the host table.
                                    </p>
    
                                    <table id="child_rows" class="table table-bordered dt-responsive nowrap" style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Name</th>
                                                <th>Position</th>
                                                <th>Office</th>
                                                <th>Salary</th>
                                            </tr>
                                        </thead>
                                    <tbody>
                                        <tr>
                                            <th></th>
                                            <th>Name</th>
                                            <th>Position</th>
                                            <th>Office</th>
                                            <th>Salary</th>
                                        </tr>
                                    </tbody>
                                    </table>        
                                </div>
                            </div>
                        </div> <!-- end col -->
                    </div> <!-- end row -->
        <!-- end page title end breadcrumb -->
       
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-header">
                            <div class="nav-link">
                                <a class=" btn btn-sm btn-soft-primary"  href="" role="button" data-bs-toggle="modal" data-bs-target="#InputDataCrew"><i class="fas fa-plus me-2"></i>New Crew</a>
                            </div>
                        </div><!--end card-header-->
                    </div><!--end card-header-->
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped mb-0">
                                <thead>
                                <tr>
                                    <th>ID Crew</th>
                                    <th>Name</th>
                                    <th>Address</th>
                                    <th>Job Title</th>
                                    <th>Date of Birth</th>
                                    <th>Gender</th>
                                    <th>Religion</th>
                                    <th>Phone</th>
                                    <th>Email</th>
                                    <th class="text-end">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                
                                    {{-- <td>10100104</td>
                                    <td><img src="{{ url('') }}/assets/images/users/user-3.jpg" alt="" class="rounded-circle thumb-xs me-1"> Irfan Sahyana</td>
                                    <td>Jl. Cijawura Hilir No. 45</td>
                                    <td>Programmer</td>
                                    <td>22-03-1981</td>
                                    <td>Man</td>
                                    <td>Islam</td>
                                    <td>Indonesia</td>
                                    <td>0853-2493-3923</td>
                                    <td>irfansahyana2000@gmail.com</td>
                                    <td class="text-end">                                                       
                                        <a href="#"><i class="las la-pen text-secondary font-16"></i></a>
                                        <a href="#"><i class="las la-trash-alt text-secondary font-16"></i></a>
                                    </td> --}}
                                    @foreach ($data as $item)
                                    <tr>
                                        <td>{{ $item->id_crew }}</td>
                                        <td><img src="{{ url('') }}/assets/images/crews/{{ $item->poto }}" alt="" class="rounded-circle thumb-xs me-1"> {{ $item->nama }}</td>
                                        <td>{{ $item->alamat }}</td>
                                        <td>{{ $item->pekerjaan }}</td>
                                        <td>{{ $item->tanggal_lahir }}</td>
                                        <td>{{ $item->jenis_kelamin }}</td>
                                        <td>{{ $item->agama }}</td>
                                        <td>{{ $item->telepon }}</td>
                                        <td>{{ $item->email }}</td>
                                        <td class="text-end">                                                       
                                            <a href="" role="button" data-bs-toggle="modal" data-bs-target="#InputDataCrew"><i class="las la-pen text-secondary font-16"></i></a>
                                            <a href="/crew/profile/{{ $item->id_crew }}"><i class="las la-user text-secondary font-16"></i></a>
                                            <a href="/crew/crew/delete/{{ $item->id_crew }}"><i class="las la-trash-alt text-secondary font-16"></i></a>
                                        </td>
                                    </tr>
                                    @endforeach 
                                </tbody>
                            </table><!--end /table-->
                        </div><!--end /tableresponsive-->
                    </div><!--end card-body-->
                </div><!--end card-->
            </div> <!-- end col -->
        </div> <!-- end row -->
    </div><!-- container -->

    <!--- Input Data  -->
    <div class="modal fade" id="InputDataCrew" tabindex="-1" aria-labelledby="exampleModalFullscreenXxlLabel" aria-hidden="true">
        <div class="modal-dialog modal-fullscreen-xxl-down">
          <div class="modal-content">
            <div class="modal-header">
              <h6 class="modal-title" id="exampleModalFullscreenXxlLabel">Parts Input Box</h6>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Parts inputs</h4>
                            </div><!--end card-header-->
                            <div class="card-body">  
                                <div class="row">
                                    <div class="col-lg-9">
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <div class="mb-2 row">
                                                    <label for="example-text-input-sm" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">ID Crew</label>
                                                    <div class="col-sm-3">
                                                        <input class="form-control form-control-sm" type="text" placeholder="" id="example-text-input-sm">
                                                    </div>
                                                </div>   
                                                <div class="mb-2 row">
                                                    <label for="example-text-input-sm" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Name</label>
                                                    <div class="col-sm-8">
                                                        <input class="form-control form-control-sm" type="text" placeholder="" id="example-text-input-sm">
                                                    </div>
                                                </div>
                                                <div class="mb-2 row">
                                                    <label for="example-url-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Job Title</label>
                                                    <div class="col-sm-8">
                                                        <input class="form-control form-control-sm" type="text"  id="example-url-input">
                                                    </div>
                                                </div> 
                                                <div class="mb-2 row">
                                                    <label for="example-date-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Address</label>
                                                    <div class="col-sm-8">
                                                        <textarea class="form-control form-control-sm" rows="3" type="text" placeholder="" id="example-text-input-sm"></textarea>
                                                    </div>
                                                </div>
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Place of Birth</label>
                                                    <div class="col-sm-8">
                                                        <input class="form-control form-control-sm" type="text" id="example-month-input">
                                                    </div>
                                                </div>             
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Date of Birth</label>
                                                    <div class="col-sm-4">
                                                        <input class="form-control form-control-sm" type="date" id="example-month-input">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-6">                                        
        
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Gender</label>
                                                    <div class="col-sm-9">
                                                        <div class="col-md-9">
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios1" value="option1" checked>
                                                                <label class="form-check-label" for="exampleRadios1">
                                                                  Man
                                                                </label>
                                                            </div>
                                                            <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios2" value="option2">
                                                                <label class="form-check-label" for="exampleRadios2">
                                                                  Female
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
        
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Religion</label>
                                                    <div class="col-sm-5">
                                                        <select class="form-select form-select-sm" name="id_group" aria-label="Default select example">
                                                            <option selected>Select one</option>
                                                            <option value="1">Islam</option>
                                                            <option value="2">Kristen</option>
                                                            <option value="3">Hindu</option>
                                                            <option value="4">Budha</option>
                                                            <option value="5">Protestan</option>
                                                            <option value="6">Konghuchu</option>
                                                          </select>
                                                    </div>
                                                </div>
        
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Country</label>
                                                    <div class="col-sm-9">
                                                        <input class="form-control form-control-sm" type="text" id="example-month-input">
                                                    </div>
                                                </div>   
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Phone</label>
                                                    <div class="col-sm-9">
                                                        <input class="form-control form-control-sm" type="text" id="example-month-input">
                                                    </div>
                                                </div>   
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Whatsapp</label>
                                                    <div class="col-sm-9">
                                                        <input class="form-control form-control-sm" type="text" id="example-month-input">
                                                    </div>
                                                </div>   
                                                <div class="mb-2 row">
                                                    <label for="example-month-input" class="col-sm-3 form-label align-self-center mb-lg-0 text-end">Email</label>
                                                    <div class="col-sm-9">
                                                        <input class="form-control form-control-sm" type="email" id="example-month-input">
                                                    </div>
                                                </div>   
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="card-body">
                                                <!-- Nav tabs -->
                                                <ul class="nav nav-pills nav-justified" role="tablist">
                                                    <li class="nav-item waves-effect waves-light">
                                                        <a class="nav-link active" data-bs-toggle="tab" href="#formaleducation" role="tab" aria-selected="true">Formal Education</a>
                                                    </li>
                                                    <li class="nav-item waves-effect waves-light">
                                                        <a class="nav-link" data-bs-toggle="tab" href="#nonformaleducation" role="tab" aria-selected="false">Non Formal Education</a>
                                                    </li>
                                                    <li class="nav-item waves-effect waves-light">
                                                        <a class="nav-link" data-bs-toggle="tab" href="#certificate" role="tab" aria-selected="false">Certificate</a>
                                                    </li>
                                                </ul>
                        
                                                <!-- Tab panes -->
                                                <div class="tab-content">
                                                    <div class="tab-pane p-3 active" id="formaleducation" role="tabpanel">
                                                        <div class="card">
                                                            <div class="card-header">
                                                                <h4 class="card-title">Edit Table With Button</h4>
                                                                <p class="text-muted mb-0">Add toolbar column with edit and delete buttons.</p>
                                                            </div><!--end card-header-->
                                                            <div class="card-body">
                                                                <button class="btn  btn-primary btn-sm mb-3" id="submit_data">Submit</button>
                                                                <div class="table-responsive">
                                                                    <table class="table  table-bordered table-sm" id="makeEditable">
                                                                        <thead>
                                                                            <tr>
                                                                                <th>Firstname</th>
                                                                                <th>Lastname</th>
                                                                                <th>Email </th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <tr>
                                                                                <td>Default</td>
                                                                                <td>Defaultson</td>
                                                                                <td>def@somemail.com</td>
                                                                            </tr>
                                                                            <tr class="success">
                                                                                <td>Success</td>
                                                                                <td>Doe</td>
                                                                                <td>john@example.com</td>
                                                                            </tr>
                                                                            <tr class="danger">
                                                                                <td>Danger</td>
                                                                                <td>Moe</td>
                                                                                <td>mary@example.com</td>
                                                                            </tr>
                                                                            <tr class="info">
                                                                                <td>Info</td>
                                                                                <td>Dooley</td>
                                                                                <td>july@example.com</td>
                                                                            </tr>
                                                                            <tr class="warning">
                                                                                <td>Warning</td>
                                                                                <td>Refs</td>
                                                                                <td>bo@example.com</td>
                                                                            </tr>
                                                                            <tr class="active">
                                                                                <td>Active</td>
                                                                                <td>Activeson</td>
                                                                                <td>act@example.com</td>
                                                                            </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                                <span class="float-right">
                                                                    <button id="but_add" class="btn btn-success btn-sm">Add New Row</button>
                                                                </span><!--end table-->     
                                                            </div><!--end card-body-->
                                                        </div><!--end card-->
                                                    </div>
                                                    <div class="tab-pane p-3" id="nonformaleducation" role="tabpanel">
                                                        <p class="text-muted mb-0">
                                                            Food truck fixie locavore, accusamus mcsweeney's
                                                            single-origin coffee squid. 
                                                        </p>
                                                    </div>
                                                    <div class="tab-pane p-3" id="certificate" role="tabpanel">
                                                        <p class="text-muted mb-0">
                                                            Trust fund seitan letterpress, keytar raw denim keffiyeh etsy.
                                                        </p>
                                                    </div>
                                                </div>    
                                            </div><!--end card-body-->
                                        </div>
                                    </div>
                                    
                                    <div class="col-lg-3">
                                        <div class="card">
                                            <div class="card-header">
                                                <h4 class="card-title">Image</h4>
                                                <p class="text-muted mb-0">You can add a part image</p>
                                            </div><!--end card-header-->
                                            <div class="card-body">
                                                <input type="file" id="input-file-now-custom-1" class="dropify" data-default-file="../plugins/dropify/images/1.jpg" />
                                            </div><!--end card-body-->
                                        </div><!--end card-->
                                        <div class="button-items"> 
                                            <button type="button" class="btn btn-primary"><i class="mdi mdi-check-all me-2"></i>Save</button>
                                            <button type="button" class="btn btn-secondary"><i class="mdi mdi-alert-outline me-2"></i>Edit</button>
                                            <button type="button" class="btn btn-warning"><i class="mdi mdi-alert-outline me-2"></i>Close</button>
                                        </div>
                                    </div>
                                </div>
                                                                                                
                            </div><!--end card-body-->
                          
                        </div><!--end card-->
                    </div><!--end col-->
                </div><!--end row-->
          
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-soft-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
          </div>
        </div>
    </div>

    <footer class="footer text-center text-sm-start">
        &copy; <script>
            document.write(new Date().getFullYear())
        </script> Dastone <span class="text-muted d-none d-sm-inline-block float-end">Crafted with <i
                class="mdi mdi-heart text-danger"></i> by Mannatthemes</span>
    </footer><!--end footer-->
</div>
<!-- end page content -->
@endsection