<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\ShipController;
use App\Http\Controllers\CrewController;
use App\Http\Controllers\DashboardDetailController;
use App\Http\Controllers\TaskjobsController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [LoginController::class, 'create'])->name('login');
Route::get('/login', [LoginController::class, 'create'])->name('login');

Route::post('/store', [LoginController::class, 'store'])->name('store');

Route::get('/dashboard', [LoginController::class, 'dashboard'])->middleware('auth:sanctum');
Route::get('/dashboard/{ship_id}', [DashboardDetailController::class, 'index'])->name('dashboard_detail')->middleware('auth:sanctum');

//Inventory
//Ship
Route::get('/inv/ship', [ShipController::class, 'index'])->name('ship')->middleware('auth:sanctum');
Route::post('/inv/ship', [ShipController::class, 'store'])->middleware('auth:sanctum');
Route::post('/inv/ship/update/{ship_id}', [ShipController::class, 'update'])->middleware('auth:sanctum');
Route::get('/inv/ship/edit/{ship_id}', [ShipController::class, 'edit'])->middleware('auth:sanctum');
Route::get('/inv/ship/{ship_id}', [ShipController::class, 'destroy'])->middleware('auth:sanctum');

//CREW
Route::get('/crew/crew', [CrewController::class, 'index'])->name('crew')->middleware('auth:sanctum');
Route::get('/crew/crew/{crew_id}', [CrewController::class, 'show'])->name('show_crew')->middleware('auth:sanctum');
Route::post('/crew/crew', [CrewController::class, 'store'])->name('store_crew')->middleware('auth:sanctum');
Route::put('/crew/crew', [CrewController::class, 'update'])->middleware('auth:sanctum');

//PMS
//Taskjobs
Route::get('/pms/taskjobs', [TaskjobsController::class, 'index'])->name('taskjobs')->middleware('auth:sanctum');
Route::get('/pms/taskjobs/{taskjob_id}', [TaskjobsController::class, 'show'])->name('show_crew')->middleware('auth:sanctum');
Route::post('/pms/taskjobs', [TaskjobsController::class, 'store'])->name('store_taskjob')->middleware('auth:sanctum');
Route::put('/pms/taskjobs/{taskjob_id}', [TaskjobsController::class, 'update'])->name('edit_taskjob')->middleware('auth:sanctum');
Route::delete('/pms/taskjobs/{taskjob_id}', [TaskjobsController::class, 'destroy'])->name('delete_taskjob')->middleware('auth:sanctum');



Route::get('/user', [LoginController::class, 'user'])->middleware('auth:sanctum');

Route::get('/logout', [LoginController::class, 'destroy'])->name('logout');

// Route::get('/', function () {
//     return view('welcome');
// });
